/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource.item;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.LambDynLightsConstants;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSource;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.resource.LightSourceLoader;
import dev.lambdaurora.lambdynlights.resource.LoadedLightSourceResource;
import dev.yumi.commons.event.Event;
import dev.yumi.mc.core.api.YumiEvents;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9275;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemLightSources
extends LightSourceLoader<ItemLightSource>
implements ItemLightSourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|ItemLightSources");
    private final Event<class_2960, ItemLightSourceManager.OnRegister> onRegisterEvent = YumiEvents.EVENTS.create(ItemLightSourceManager.OnRegister.class);

    public ItemLightSources(LightSourceLoader.ApplicationPredicate applicationPredicate) {
        super(applicationPredicate);
    }

    @Override
    @NotNull
    public class_2960 id() {
        return RESOURCE_RELOADER_ID;
    }

    @Override
    public @Unmodifiable Collection<class_2960> dependencies() {
        return List.of();
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getResourcePath() {
        return "item";
    }

    @Override
    protected void doApply(final class_7225.class_7874 registryLookup, final List<ItemLightSource> lightSources) {
        ((ItemLightSourceManager.OnRegister)this.onRegisterEvent.invoker()).onRegister(new ItemLightSourceManager.RegisterContext(){

            @NotNull
            public class_7225.class_7874 registryLookup() {
                return registryLookup;
            }

            public void register(@NotNull ItemLightSource itemLightSource) {
                lightSources.add(itemLightSource);
            }
        });
    }

    @Override
    @NotNull
    protected Optional<ItemLightSource> apply(DynamicOps<JsonElement> ops, LoadedLightSourceResource loadedData) {
        DataResult loaded = ItemLightSource.CODEC.parse(ops, (Object)loadedData.data());
        if (!loadedData.silenceError() || LambDynLightsConstants.FORCE_LOG_ERRORS) {
            loaded.ifError(error -> LambDynLights.warn(LOGGER, "Failed to load item light source \"{}\" due to error: {}", loadedData.id(), error.message()));
        }
        return loaded.result();
    }

    @NotNull
    public Event<class_2960, ItemLightSourceManager.OnRegister> onRegisterEvent() {
        return this.onRegisterEvent;
    }

    public int getLuminance(@NotNull class_1799 stack, boolean submergedInWater) {
        boolean shouldCareAboutWater = submergedInWater && (Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get() != false;
        int luminance = 0;
        boolean matchedAny = false;
        for (ItemLightSource data : this.lightSources) {
            if (!data.predicate().method_8970(stack)) continue;
            matchedAny = true;
            if (shouldCareAboutWater && data.waterSensitive()) continue;
            luminance = Math.max(luminance, data.getLuminance(stack));
        }
        if (!matchedAny) {
            ItemLightSource data;
            data = stack.method_7909();
            if (data instanceof class_1747) {
                class_1747 blockItem = (class_1747)data;
                class_2680 state = blockItem.method_7711().method_9564();
                class_9275 component = (class_9275)stack.method_58695(class_9334.field_49623, (Object)class_9275.field_49284);
                if (!component.method_57414()) {
                    state = component.method_57415(state);
                }
                luminance = state.method_26213();
            } else {
                luminance = class_2248.method_9503((class_1792)stack.method_7909()).method_9564().method_26213();
            }
        }
        return luminance;
    }
}

